<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Address extends Model 
{

    protected $table = 'addresses';
    public $timestamps = true;
    protected $fillable = array('nickname', 'address', 'street', 'street_additional', 'city', 'state', 'country', 'zipcode', 'latitude', 'longitude');
    protected $visible = array('nickname', 'address', 'street', 'street_additional', 'city', 'state', 'country', 'zipcode', 'latitude', 'longitude');

    public function user()
    {
        return $this->belongsTo('App\Models\User')->withPivot('address_pivot');
    }

}